/*
 *  Tank.java
 */

package Experiment;

import javax.media.opengl.*;
import com.sun.opengl.util.GLUT;

// base class for tanks (player and enemy)
abstract public class Tank extends Sprite {

  // material details
  private static final float kDiffuseColour[]  = { 0.0f, 0.0f, 0.0f, 1.0f },
                             kSpecularColour[] = { 0.4f, 0.4f, 0.4f, 1.0f };
  private static final float kShininess        = 8.0f;
  
  // outline details
  private static final float kLineColour[] = { 1.0f, 1.0f, 1.0f, 1.0f };
  
  // object shape
  private static final float kOffsetX      = +2.0f,
                             kBaseY        = +0.0f,
                             kFrontCornerX = +5.0f,
                             kFrontCornerZ = +1.7f,
                             kBackCornerX  = -1.0f,
                             kBackCornerZ  = +2.0f,
                             kTopCornerY   = +3.0f,
                             kTopCornerZ   = +1.7f,
                             kGunX         = +4.5f,
                             kGunY         = +1.9f,
                             kGunRadius    = 0.4f;
  
  // display list
  private static int kDisplayList = 0;

  // position
  protected float mXPos,
                  mZPos;
  
  // direction in (x,z) plane is (cos,sin), in degrees
  protected float mAngle;

  // prepare display list
  static public void init(GL gl) {
  
    if ( kDisplayList != 0 ) return; // already initialized

    kDisplayList = gl.glGenLists(1);
    gl.glNewList(kDisplayList, GL.GL_COMPILE);
    gl.glPushMatrix();
    
    gl.glMaterialfv(GL.GL_FRONT, GL.GL_AMBIENT_AND_DIFFUSE, kDiffuseColour, 0);
    gl.glMaterialfv(GL.GL_FRONT, GL.GL_SPECULAR, kSpecularColour, 0);
    gl.glMaterialf(GL.GL_FRONT, GL.GL_SHININESS, kShininess);

    gl.glShadeModel(GL.GL_FLAT);
    gl.glPolygonOffset(1.0f, 1.0f);
    gl.glEnable(GL.GL_POLYGON_OFFSET_FILL);
    addTankShapes(gl, false);
    gl.glDisable(GL.GL_POLYGON_OFFSET_FILL);

    gl.glDisable(GL.GL_LIGHTING);
    gl.glEnable(GL.GL_LINE_SMOOTH);
    gl.glEnable(GL.GL_BLEND);
    gl.glColor4fv(kLineColour, 0);
    addTankShapes(gl, true);
    gl.glDisable(GL.GL_BLEND);
    gl.glEnable(GL.GL_LIGHTING);
    
    gl.glPopMatrix();
    gl.glEndList();

    assert( kDisplayList > 0 );
  
  } // init()
  
  // accessors
  public float getXPos() { return mXPos; }
  public float getZPos() { return mZPos; }
  public float getAngle() { return mAngle; }
  
  // draw the object
  public void display(GL gl) {
    
    assert( kDisplayList > 0 );
  
    gl.glPushMatrix();
    gl.glTranslatef(mXPos, 0.0f, mZPos);
    gl.glRotatef(-mAngle, 0.0f, 1.0f, 0.0f);
    gl.glCallList(kDisplayList);
    gl.glPopMatrix();
    
  } // Sprite.display()

  // triangles and quads that make up the tank
  static private void addTankShapes(GL gl, boolean outline) {

    float dx = -kOffsetX;
    addTriangle(gl, dx+kBackCornerX,  kBaseY,      +kBackCornerZ,
                    dx+kFrontCornerX, kBaseY,      +kFrontCornerZ,
                    dx+0.0f,          kTopCornerY, +kTopCornerZ, outline);
    addTriangle(gl, dx+kFrontCornerX, kBaseY,      -kFrontCornerZ,
                    dx+kBackCornerX,  kBaseY,      -kBackCornerZ,
                    dx+0.0f,          kTopCornerY, -kTopCornerZ, outline);
    addQuad(gl, dx+kFrontCornerX, kBaseY,      +kFrontCornerZ,
                dx+kFrontCornerX, kBaseY,      -kFrontCornerZ,
                dx+0.0f,          kTopCornerY, -kTopCornerZ,
                dx+0.0f,          kTopCornerY, +kTopCornerZ, outline);
    addQuad(gl, dx+kBackCornerX,  kBaseY,      +kBackCornerZ,
                dx+0.0f,          kTopCornerY, +kTopCornerZ,
                dx+0.0f,          kTopCornerY, -kTopCornerZ,
                dx+kBackCornerX,  kBaseY,      -kBackCornerZ, outline);
    addQuad(gl, dx+kGunX, kGunY-kGunRadius, +kGunRadius,
                dx+kGunX, kGunY+kGunRadius, +kGunRadius,
                dx+0.0f,  kGunY+kGunRadius, +kGunRadius,
                dx+0.0f,  kGunY-kGunRadius, +kGunRadius, outline);
    addQuad(gl, dx+kGunX, kGunY-kGunRadius, -kGunRadius,
                dx+0.0f,  kGunY-kGunRadius, -kGunRadius,
                dx+0.0f,  kGunY+kGunRadius, -kGunRadius,
                dx+kGunX, kGunY+kGunRadius, -kGunRadius, outline);
    addQuad(gl, dx+kGunX, kGunY-kGunRadius, +kGunRadius, 
                dx+0.0f,  kGunY-kGunRadius, +kGunRadius,
                dx+0.0f,  kGunY-kGunRadius, -kGunRadius, 
                dx+kGunX, kGunY-kGunRadius, -kGunRadius, outline);
    addQuad(gl, dx+0.0f,  kGunY+kGunRadius, +kGunRadius, 
                dx+kGunX, kGunY+kGunRadius, +kGunRadius, 
                dx+kGunX, kGunY+kGunRadius, -kGunRadius, 
                dx+0.0f,  kGunY+kGunRadius, -kGunRadius, outline);
    addQuad(gl, dx+kGunX, kGunY+kGunRadius, +kGunRadius,
                dx+kGunX, kGunY-kGunRadius, +kGunRadius,
                dx+kGunX, kGunY-kGunRadius, -kGunRadius,
                dx+kGunX, kGunY+kGunRadius, -kGunRadius, outline);
    
  } // addTankShapes()
  
} // class Tank
