/*
 *  Sprite.java
 */

package Experiment;

import java.util.*;
import javax.media.opengl.*;

// base class for game objects (includes some helper functions)
abstract public class Sprite {

  // update the state of the object based on dt seconds passing
  public void advance(float dt) {}
  
  // render the object
  public void display(GL gl) {}

  // helper function: 
  // draw a single flat triangle (vertices anticlockwise from the inside)
  static protected void addTriangle(GL gl, 
                                    float x0, float y0, float z0,
                                    float x1, float y1, float z1,
                                    float x2, float y2, float z2,
                                    boolean outline) {
  
    if ( outline ) {
      gl.glBegin(GL.GL_LINE_LOOP);
        gl.glVertex3f(x0, y0, z0);
        gl.glVertex3f(x1, y1, z1);
        gl.glVertex3f(x2, y2, z2);
      gl.glEnd();
    } else {
      gl.glBegin(GL.GL_TRIANGLES);
        addNormal(gl, x0,y0,z0, x1,y1,z1, x2,y2,z2);
        gl.glVertex3f(x0, y0, z0);
        gl.glVertex3f(x1, y1, z1);
        gl.glVertex3f(x2, y2, z2);
      gl.glEnd();
    }
    
  } // addTriangle()
  
  // helper function: 
  // draw a flat(-ish) quadrilateral (vertices anticlockwise from the inside)
  static protected void addQuad(GL gl, 
                                float x0, float y0, float z0,
                                float x1, float y1, float z1,
                                float x2, float y2, float z2,
                                float x3, float y3, float z3,
                                boolean outline) {

    if ( outline ) {
      gl.glBegin(GL.GL_LINE_LOOP);
        gl.glVertex3f(x0, y0, z0);
        gl.glVertex3f(x1, y1, z1);
        gl.glVertex3f(x2, y2, z2);
        gl.glVertex3f(x3, y3, z3);
      gl.glEnd();
    } else {
      gl.glBegin(GL.GL_TRIANGLE_STRIP);
        addNormal(gl, x0,y0,z0, x1,y1,z1, x3,y3,z3);
        gl.glVertex3f(x0, y0, z0);
        gl.glVertex3f(x1, y1, z1);
        gl.glVertex3f(x3, y3, z3);
        gl.glVertex3f(x2, y2, z2);
      gl.glEnd();
    }
    
  } // addQuad()

  // helper function: 
  // define a normal vector for a flat triangle (un-normalized)
  static protected void addNormal(GL gl, float x0, float y0, float z0,
                                         float x1, float y1, float z1,
                                         float x2, float y2, float z2) {
    
    float dx1 = x1 - x0,
          dy1 = y1 - y0,
          dz1 = z1 - z0;
    float dx2 = x2 - x0,
          dy2 = y2 - y0,
          dz2 = z2 - z0;
    float xn = dy1*dz2 - dy2*dz1,
          yn = dz1*dx2 - dz2*dx1,
          zn = dx1*dy2 - dx2*dy1;
    gl.glNormal3f(xn, yn, zn);
    
  } // addNormal()
  
} // class Sprite
