/*
 *  Player.java
 */

package Experiment;

// the player (viewer) details
public class Player extends Tank {

  // details of motion
  private static final float kSpeed    = 15.0f,
                             kAngSpeed = 60.0f;

  // constructor
  public Player() {
  
    mXPos = 0.0f;
    mZPos = 45.0f;
    mAngle = -90.0f;
  
  } // constructor
  
  // change position, etc.
  public void advance(float dt) {
  
    boolean keyForward = Env.keys().up(),
            keyReverse = Env.keys().down(),
            keyLeft    = Env.keys().left(),
            keyRight   = Env.keys().right();
            
    if ( keyRight && !keyLeft ) {
      mAngle += dt*kAngSpeed;
    } else if ( keyLeft && !keyRight ) {
      mAngle -= dt*kAngSpeed;
    }
    
    float d = 0.0f;
    if ( keyForward && !keyReverse ) {
      d = +kSpeed*dt;
    } else if ( keyReverse && !keyForward ) {
      d = -kSpeed*dt;
    }
    if ( d != 0.0f ) {
      mXPos += d*(float)Math.cos(mAngle*Math.PI/180.0f);
      mZPos += d*(float)Math.sin(mAngle*Math.PI/180.0f);
    }
  
  } // Sprite.advance()
  
} // class Player
