/*
 *  Obstacle.java
 */

package Experiment;

import javax.media.opengl.*;
import com.sun.opengl.util.GLUT;

// a stationary object
public class Obstacle extends Sprite {

  // material details
  private static final float kDiffuseColour[]  = { 0.0f, 0.0f, 0.0f, 1.0f },
                             kSpecularColour[] = { 0.4f, 0.4f, 0.4f, 1.0f };
  private static final float kShininess        = 8.0f;
  
  // outline details
  private static final float kLineColour[] = { 1.0f, 1.0f, 1.0f, 1.0f };
  
  // object shape
  private static final int   kNumSides = 6;
  private static final float kHeight   = 10.0f,
                             kRadius   = 5.0f;
  
  // display list
  private static int kDisplayList = 0;

  // position
  private float mXPos,
                mZPos;
  
  // direction in (x,z) plane is (cos,sin), in degrees
  private float mAngle;

  // prepare display list
  static public void init(GL gl) {
  
    if ( kDisplayList != 0 ) return; // already initialized

    kDisplayList = gl.glGenLists(1);
    gl.glNewList(kDisplayList, GL.GL_COMPILE);
    gl.glPushMatrix();
    
    gl.glMaterialfv(GL.GL_FRONT, GL.GL_AMBIENT_AND_DIFFUSE, kDiffuseColour, 0);
    gl.glMaterialfv(GL.GL_FRONT, GL.GL_SPECULAR, kSpecularColour, 0);
    gl.glMaterialf(GL.GL_FRONT, GL.GL_SHININESS, kShininess);

    gl.glShadeModel(GL.GL_FLAT);
    gl.glPolygonOffset(1.0f, 1.0f);
    gl.glEnable(GL.GL_POLYGON_OFFSET_FILL);
    addObstacleShapes(gl, false);
    gl.glDisable(GL.GL_POLYGON_OFFSET_FILL);

    gl.glDisable(GL.GL_LIGHTING);
    gl.glEnable(GL.GL_LINE_SMOOTH);
    gl.glEnable(GL.GL_BLEND);
    gl.glColor4fv(kLineColour, 0);
    addObstacleShapes(gl, true);
    gl.glDisable(GL.GL_BLEND);
    gl.glEnable(GL.GL_LIGHTING);
    
    gl.glPopMatrix();
    gl.glEndList();

    assert( kDisplayList > 0 );
  
  } // init()
  
  // constructor
  public Obstacle(float xPos, float zPos, float angle) {
  
    mXPos  = xPos;
    mZPos  = zPos;
    mAngle = angle;
  
  } // constructor
  
  // accessors
  public float getXPos() { return mXPos; }
  public float getZPos() { return mZPos; }
  public float getAngle() { return mAngle; }
  
  // draw the object
  public void display(GL gl) {
    
    assert( kDisplayList > 0 );
  
    gl.glPushMatrix();
    gl.glTranslatef(mXPos, 0.0f, mZPos);
    gl.glRotatef(-mAngle, 0.0f, 1.0f, 0.0f);
    gl.glCallList(kDisplayList);
    gl.glPopMatrix();
    
  } // Sprite.display()

  // triangles and quads that make up the obstacle
  static private void addObstacleShapes(GL gl, boolean outline) {

    float dTheta = 2.0f*(float)Math.PI/kNumSides;
    for ( int k = 0 ; k < kNumSides ; k++ ) {
      float theta1 = k*dTheta,
            theta2 = ( (k+1 == kNumSides) ? 0.0f : ((k+1)*dTheta) );
      float x1 = kRadius*(float)Math.cos(theta1),
            z1 = kRadius*(float)Math.sin(theta1),
            x2 = kRadius*(float)Math.cos(theta2),
            z2 = kRadius*(float)Math.sin(theta2);
      addTriangle(gl, x1,   0.0f,    z1,
                      0.0f, kHeight, 0.0f,
                      x2,   0.0f,    z2, outline);
    }
    
  } // addObstacleShapes()
  
} // class Obstacle
