/*
 *  Mountains.java
 */
 
package Experiment;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.media.opengl.*;
import javax.media.opengl.glu.*;
import com.sun.opengl.util.*;

// display of mountains along the horizon
// (basically just a 2D image drawn in the background)
public class Mountains {

  // appearance
  private static final float kLineColour[] = { 1.0f, 1.0f, 1.0f, 1.0f },
                             kFillColour[] = { 0.0f, 0.0f, 0.0f, 1.0f };
  
  // details of mountain peaks
  private static final int   kNumPeaks = 18;
  private static final float kMountainMinHeight = 0.02f,
                             kMountainMaxHeight = 0.13f;
  
  // heights of peaks in the mountain range
  private float mHeights[];
  
  // constructor
  public Mountains() {
  
    mHeights = new float[kNumPeaks];
    float midHeight   = 0.5f*(kMountainMinHeight + kMountainMaxHeight),
          deltaHeight = 0.2f*(kMountainMaxHeight - kMountainMinHeight);
    for ( int k = 0 ; k < kNumPeaks ; k++ ) {
      float min = ((k%2==0) ? kMountainMinHeight : midHeight),
            max = ((k%2==0) ? midHeight : kMountainMaxHeight );
      boolean done = false;
      while ( !done ) {
        mHeights[k] = Env.randomFloat(min, max);
        if ( k == 0 ) {
          done = true;
        } else {
          done = ( Math.abs(mHeights[k]-mHeights[k-1]) > deltaHeight );
          if ( k == kNumPeaks-1 ) {
            done = done && ( Math.abs(mHeights[k]-mHeights[0]) > deltaHeight );
          }
        }
      }
    }

  } // constructor
  
  // draw the mountains (and their reflection)
  // ("viewAngle" is the camera direction in degrees)
  // ("viewWidth" is the half-angle of the view)
  // (game expected to be in 'ortho' mode, |x|<=AspectRatio & |y|<=1)
  public void display(GL gl, float viewAngle, float viewWidth) {
  
    float mountainDegrees = 90.0f/kNumPeaks;
    float dx = Env.aspectRatio()*mountainDegrees/viewWidth;

    float firstMountain = (viewAngle-viewWidth)/mountainDegrees;
    int indexStart = Env.fold((int)Math.floor(firstMountain), kNumPeaks);
    
    float xOffset = (firstMountain - (float)Math.floor(firstMountain))*dx;
    float xMin = -(Env.aspectRatio() + xOffset),
          xMax = Env.aspectRatio() + dx;
    
    gl.glShadeModel(GL.GL_FLAT);
    
    gl.glColor4fv(kFillColour, 0);
    gl.glBegin(GL.GL_QUAD_STRIP);
      int index = indexStart;
      for ( float x = xMin ; x <= xMax ; x += dx ) {
        float y = mHeights[index];
        gl.glVertex2f(x, +y);
        gl.glVertex2f(x, -y);
        if ( ++index >= kNumPeaks ) index -= kNumPeaks;
      }
    gl.glEnd();

    gl.glEnable(GL.GL_LINE_SMOOTH);
    gl.glEnable(GL.GL_BLEND);
    
    gl.glColor4fv(kLineColour, 0);
    gl.glBegin(GL.GL_LINE_STRIP);
      index = indexStart;
      for ( float x = xMin ; x <= xMax ; x += dx ) {
        gl.glVertex2f(x, +mHeights[index]);
        if ( ++index >= kNumPeaks ) index -= kNumPeaks;
      }
    gl.glEnd();
    gl.glBegin(GL.GL_LINE_STRIP);
      index = indexStart;
      for ( float x = xMin ; x <= xMax ; x += dx ) {
        gl.glVertex2f(x, -mHeights[index]);
        if ( ++index >= kNumPeaks ) index -= kNumPeaks;
      }
    gl.glEnd();

    gl.glDisable(GL.GL_BLEND);
    
  } // display()

} // class Mountains
 