/*
 *  Env.java
 */

package Experiment;

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import java.util.*;
import javax.media.opengl.glu.*;

// some global variables and functions
public class Env {

  // the component that's in charge
  static private Component kOwner;

  // whether to display debug messages, timing statistics
  static private boolean kDebugMode        = false,
                         kPerformanceStats = false;
  
  // ratio of width to height of the JOGL canvas
  static private float kAspectRatio = 1.0f;
  
  // assorted helper objects
  static private Random     kRandom;
  static private KeyMonitor kKeyMonitor;
  //static private Resources  kResources;
  //static private Sounds     kSounds;
  static private GLU        kGlu;
  
  // this sets up a global Env for the application
  static public void initialize(Component owner) {
  
    kOwner = owner;

    kRandom     = new Random();
    kKeyMonitor = new KeyMonitor(owner);
    //kResources  = new Resources();
    //kSounds     = new Sounds();
    kGlu        = null;
    
  } // initialize()

  // whether debug messages, timing statistics should be displayed
  static public boolean debugMode() { return kDebugMode; }
  static public boolean performanceStats() { return kPerformanceStats; }
  static public void setVerbose() { kDebugMode = kPerformanceStats = true; }

  // ratio of screen dimensions (width divided by height)
  static public float aspectRatio() { return kAspectRatio; }
  static public void setAspectRatio(float a) { kAspectRatio = a; }
  
  // return reference to keyboard monitor
  static public KeyMonitor keys() { return kKeyMonitor; }
  
  // return reference to game resources
  //static public Resources resources() { return kResources; }
  
  // return reference to game audio
  //static public Sounds sounds() { return kSounds; }

  // return reference to GLU instance
  static public GLU glu() { return kGlu; }
  static public void setGlu(GLU glu) { kGlu = glu; }
  
  // assorted functions for returning random numbers
  static public float randomFloat() { // in range [0,1]
    return kRandom.nextFloat(); 
  } // randomFloat()
  static public float randomFloat(float a, float b) { // in range [a,b] 
    return ( a + (b-a)*kRandom.nextFloat() ); 
  } // randomFloat()
  static public double randomDouble() { // in range [0,1]
    return kRandom.nextDouble(); 
  } // randomDouble()
  static public double randomDouble(double a, double b) { // in range [a,b] 
    return ( a + (b-a)*kRandom.nextDouble() ); 
  } // randomDouble()
  static public int randomInt(int n) { // in range [0,n-1] 
    return kRandom.nextInt(n); 
  } // randomInt()
  static public int randomInt(int a, int b) { // in range [a,b]
    if ( a > b )      return ( b + kRandom.nextInt(a-b+1) );
    else if ( a < b ) return ( a + kRandom.nextInt(b-a+1) );
    else              return a;
  } // randomInt()
  static public boolean randomBoolean() { 
    return kRandom.nextBoolean(); 
  } // randomBoolean()

  // assorted modulo-type functions
  static public int fold(int a, int b) {
    // result is between 0 and (b-1)
    if ( a >= 0 ) return (a%b);
    else {
      int temp = b + (a%b);
      return ( (temp==b) ? 0 : temp );
    }
  } // fold()
  static public double fold(double a, double b) {
    // result is in interval [0,b)
    // (probably a more efficient way of doing this?)
    return ( a - b*Math.floor(a/b) );
  } // fold()
  static public float fold(float a, float b) {
    // result is in interval [0,b)
    // (probably a more efficient way of doing this?)
    return ( a - b*(float)Math.floor(a/b) );
  } // fold()
  
  // more modulo-type functions
  static public float foldNearTo(float a, float target, float modSize) {
    return ( target + fold(a-target+0.5f*modSize, modSize) - 0.5f*modSize );
  } // foldNearTo()
  
} // class Env
