/*
 *  EnemyTank.java
 */

package Experiment;

// an evil tank
public class EnemyTank extends Tank {

  // circular path
  private static final float kPathRadius = 9.0f,
                             kPathSpeed  = 90.0f;
  
  // piecewise spin along path
  private static final float kSpinSpeed    = 67.0f,
                             kSpinFraction = 0.2f;
                             
  // position on path
  private float mPathAngle;
  
  // angle during spin
  private float mSpinAngle;
  
  // constructor
  public EnemyTank(float angle) {

    mPathAngle = Env.fold(angle, 360.0f);
    mSpinAngle = 0.0f;
    updatePosition();

  } // constructor

  // update (x,z) coordinates based on current angle
  private void updatePosition() {

    float theta = mPathAngle*(float)Math.PI/180.0f;
    mXPos = kPathRadius*(float)Math.cos(theta);
    mZPos = kPathRadius*(float)Math.sin(theta);
    
    float spinA = Env.fold(mSpinAngle, 90.0f),
          spinB = mSpinAngle - spinA,
          spin  = spinB + Math.min(90.0f, spinA/kSpinFraction);
    mAngle = mPathAngle + 90.0f + spin;
    
  } // updatePosition()
  
  // update object position, etc. by dt seconds
  public void advance(float dt) {
  
    mPathAngle = Env.fold(mPathAngle + kPathSpeed*dt, 360.0f);
    mSpinAngle = Env.fold(mSpinAngle + kSpinSpeed*dt, 360.0f);
    updatePosition();
    
  } // Sprite.advance()
  
} // class EnemyTank
